

#include <avr/io.h>
#include <util/delay.h>
#include <stdint.h>
#include <avr/interrupt.h>

void sleep_ms(uint16_t ms);

#define LED_WS			PC0
#define LED_BL			PC1
#define LED_BLITZRT		PC2
#define LED_BLITZGN		PC3
#define LED_4			PC4
#define LED_HINTENGN	PC5
#define LED_HINTENRT	PD4
#define LED_VORNEGN		PD5
#define LED_UNTENGB		PD6
#define LED_VORNERT		PD7
#define LED_STATUS		PB0

#define STATUS_OFF		PORTB |= (1<<LED_STATUS)	//Den Portpin auf high setzen
#define STATUS_ON		PORTB &= ~(1<<LED_STATUS)	//Den Portpin auf low setzen
#define STATUS_TOGGLE	PORTB ^= ~(1<<LED_STATUS)	//Den Portpin toggeln
#define BLITZGN_ON		PORTC |= (1<<LED_BLITZGN)	//Den Portpin auf high setzen
#define BLITZGN_OFF		PORTC &= ~(1<<LED_BLITZGN)	//Den Portpin auf low setzen
#define BLITZRT_ON		PORTC |= (1<<LED_BLITZRT)	//Den Portpin auf high setzen
#define BLITZRT_OFF		PORTC &= ~(1<<LED_BLITZRT)	//Den Portpin auf low setzen
#define WEISS_ON		PORTC |= (1<<LED_WS)		//Den Portpin auf high setzen
#define WEISS_OFF		PORTC &= ~(1<<LED_WS)		//Den Portpin auf low setzen
#define BLAU_ON			PORTC |= (1<<LED_BL)		//Den Portpin auf high setzen
#define BLAU_OFF		PORTC &= ~(1<<LED_BL)		//Den Portpin auf low setzen
#define GELB_ON			PORTD |= (1<<LED_UNTENGB)	//Den Portpin auf high setzen
#define GELB_OFF		PORTD &= ~(1<<LED_UNTENGB)	//Den Portpin auf low setzen
#define VORNGN_ON		PORTD |= (1<<LED_VORNEGN)	//Den Portpin auf high setzen
#define VORNGN_OFF		PORTD &= ~(1<<LED_VORNEGN)	//Den Portpin auf low setzen
#define HINTENGN_ON		PORTC |= (1<<LED_HINTENGN)	//Den Portpin auf high setzen
#define HINTENGN_OFF	PORTC &= ~(1<<LED_HINTENGN)	//Den Portpin auf low setzen
#define VORNRT_ON		PORTD |= (1<<LED_VORNERT)	//Den Portpin auf high setzen
#define VORNRT_OFF		PORTD &= ~(1<<LED_VORNERT)	//Den Portpin auf low setzen
#define HINTENRT_ON		PORTD |= (1<<LED_HINTENRT)	//Den Portpin auf high setzen
#define HINTENRT_OFF	PORTD &= ~(1<<LED_HINTENRT)	//Den Portpin auf low setzen

#define ALLES_OFF		BLITZGN_OFF;BLITZRT_OFF;WEISS_OFF;BLAU_OFF;GELB_OFF;VORNGN_OFF;HINTENGN_OFF;VORNRT_OFF;HINTENRT_OFF
#define ALLES_ON		BLITZGN_ON;BLITZRT_ON;WEISS_ON;BLAU_ON;GELB_ON;VORNGN_ON;HINTENGN_ON;VORNRT_ON;HINTENRT_ON



#define F_CPU 1000000UL 

#ifndef F_CPU
#define F_CPU    1000000
#endif


volatile uint8_t mode = 0;
volatile uint8_t abbruch = 0;


ISR(INT1_vect)       
{
   // Interrupt Code 
	if (mode <= 3)
	{
	mode++;
	}
	else
	{
	mode = 0;
	}
	STATUS_TOGGLE;
	abbruch = 1;
}



int main(void){
	
	//Ports einstellen:
    //PB0 als Ausgang setzen
	DDRB |= (1<<PB0);

	// Pin C |7|6|5|4|3|2|1|0
    // Binr:|0|0|1|1|1|1|1|1 (b) => #3F (h)
	// Pin C0 bis C5 als Ausgnge festlegen   
    DDRC = 0x3F;
	
	// Pin D |7|6|5|4|3|2|1|0
    // Binr:|1|1|1|1|0|0|0|0 (b) => #F0 (h)
	DDRD = 0xF0;
	//Pullup fr PD3 aktivieren
	PORTD |= (1 << PD3);
	
	
	//interrupt konfigurueren
	GIMSK = 1<<INT1;
	MCUCR = 1<<ISC10;

	ALLES_OFF;
	STATUS_OFF;
	sleep_ms(3000);
	STATUS_ON;
	sei();	//interrupts einschalten
	
		
	while(1){
		
		
		abbruch = 0;
		if (mode == 0)
			{
			BLITZRT_OFF;
			BLITZGN_OFF;
			WEISS_ON;
			sleep_ms(50);
			WEISS_OFF;
			BLAU_ON;
			sleep_ms(50);
			BLAU_OFF;
			VORNGN_ON;
			HINTENGN_ON;
			sleep_ms(50);
			VORNGN_OFF;
			HINTENGN_OFF;
			VORNRT_ON;
			HINTENRT_ON;
			sleep_ms(50);
			VORNRT_OFF;
			HINTENRT_OFF;			
			}
		
		if (mode == 1) //mit diesem Mode wird gestartet
			{
			ALLES_OFF;
			}
		
		if (mode == 2) 
			{
			ALLES_ON;		
			}
			
		if (mode == 3)	//Dieser Mode ist nach dem Kalibrieren an
			{
			WEISS_OFF;
			BLAU_OFF;
			GELB_ON;
			VORNGN_OFF;
			HINTENGN_OFF;
			HINTENRT_OFF;
			VORNRT_OFF;
			BLITZGN_ON;	
			sleep_ms(30);
			BLITZGN_OFF;
			sleep_ms(60);
			BLITZRT_ON;
			sleep_ms(30);
			BLITZRT_OFF;
			sleep_ms(200);
			BLITZGN_ON;	
			sleep_ms(30);
			BLITZGN_OFF;
			BLITZRT_ON;
			sleep_ms(30);
			BLITZRT_OFF;
			sleep_ms(1000);
			}			
			
		if (mode == 4)
			{
			WEISS_ON;
			BLAU_ON;
			GELB_ON;
			VORNGN_OFF;
			HINTENGN_OFF;
			HINTENRT_OFF;
			VORNRT_OFF;
			BLITZGN_ON;	
			sleep_ms(30);
			BLITZGN_OFF;
			sleep_ms(60);
			BLITZRT_ON;
			sleep_ms(30);
			BLITZRT_OFF;
			sleep_ms(200);
			BLITZGN_ON;	
			sleep_ms(30);
			BLITZGN_OFF;
			BLITZRT_ON;
			sleep_ms(30);
			BLITZRT_OFF;
			sleep_ms(1000);
			}			
		
		else
			{
			sleep_ms(10);
			}	
	}
}


void sleep_ms(uint16_t ms){
	if (abbruch == 0)
		{
		while(ms)
			{
			if (abbruch != 0)
				{
				break;
				}
				else
				{
				ms--;
				_delay_ms(1);
				}
			}
		}
}
