
//LEDs has to connect between J3/J4/J5 and GND
//backward LED (red ball) connect between J10 and GND
#define F_CPU 8000000

#include <avr/io.h>
#include <util/delay.h>
#include <avr/interrupt.h>
#include "config.h"

volatile uint8_t on =0;
volatile uint8_t oncounter=0; 


void init()
{
	uint8_t sreg = SREG;
	cli();

	//Low Mosfets as output
	DDRD |= (1<<PD3) | (1<<PD4) | (1<<PD5);
	PORTD = 0x00;
	DDRC = 0x00;

	//PWM using Timer1 and Timer2
	//timer 1: fast PWM, 8Bit, noninverting
	TCCR1A |= (1<<COM1A1) | (1<<COM1B1) | (1<<WGM12) | (1<<WGM10);
	TCCR1B |= (1<<CS12); //prescaler 256 -> 32kHz
	OCR1AH = 0x00;
	OCR1BH = 0x00;

	//timer 2: fast pwm, noninverting, prescale 256 ->32kHz
	TCCR2 |= (1<<WGM21) | (1<<WGM20) | (1<<COM21) | (1<<CS22) | (1<<CS21);


//	SETPWM(0xFF);

	//external interrupt INT0 for switching on/off
	//logical change
	MCUCR |= (1<<ISC01) |(1<<ISC00);
	GICR |= (1<<INT0);
	
//	DDRD &= ~(1<<PD2);
//	PORTD |= (1<<PD2);

	SREG = sreg;
}




//all lights on
//param dim - lightness
void lightset1(uint8_t dim, uint16_t delaytime)
{
	SETPWM(dim);
	FRONT_ON;
	LEFT_ON;
	RIGHT_ON;
	BACK_ON;

	do
	{
		_delay_ms(20);
	}while (on);
	FRONT_OFF;
	LEFT_OFF;
	RIGHT_OFF;
	BACK_OFF;
}


//hard blinking, all LEDs
void lightset2(uint8_t dim, uint16_t delaytime)
{
	SETPWM(dim);
	do
	{
		_delay_ms(delaytime);
		FRONT_ON;
		LEFT_ON;
		RIGHT_ON;
//		BACK_ON;
		_delay_ms(delaytime);
		FRONT_OFF;
		LEFT_OFF;
		RIGHT_OFF;
		BACK_OFF;	
		
	}while (on);
}


// blink lights clockwise direction 
//param dim - lightness
void lightset3(uint8_t dim, uint16_t delaytime)
{
	SETPWM(dim);
	BACK_ON;

	do
	{
		_delay_ms(delaytime);
		LEFT_OFF;
		FRONT_ON;
		_delay_ms(delaytime);
		FRONT_OFF;
		RIGHT_ON;
		_delay_ms(delaytime);
		RIGHT_OFF;
		LEFT_ON;
	} while (on);
	FRONT_OFF;
	LEFT_OFF;
	RIGHT_OFF;
	BACK_OFF;
}

//pulse light, alle LEDS
void lightset4(uint8_t dim, uint16_t delaytime)
{
	int i;
	SETPWM(0);
	FRONT_ON;
	LEFT_ON;
	RIGHT_ON;
	BACK_ON;

	delaytime = delaytime /dim; 
	if (delaytime == 0) delaytime = 1;
	
	
	
	do
	{
		for (i=0;i<dim;i++)
		{	
			SETPWM(i);
			_delay_ms(delaytime);
		}
	
		for (i=dim-1;i>=0;i--)
		{	
			SETPWM(i);
			_delay_ms(delaytime);
		}
	
	} while (on);
	FRONT_OFF;
	LEFT_OFF;
	RIGHT_OFF;
	BACK_OFF;	
}

//flash lights
void lightset5(uint8_t dim, uint16_t delaytime)
{
	SETPWM(dim);
	do
	{
		_delay_ms(delaytime);
		FRONT_ON;
		LEFT_ON;
		RIGHT_ON;
		_delay_ms(80);
		FRONT_OFF;
		LEFT_OFF;
		RIGHT_OFF;

	} while (on);
	FRONT_OFF;
	LEFT_OFF;
	RIGHT_OFF;
	BACK_OFF;
}





int main()
{
	init();
	sei();

	

	FRONT_OFF;
	LEFT_OFF;
	RIGHT_OFF;
	BACK_OFF;	
	
	LED_GREEN_ON;
	LED_RED_OFF;

	

	while(1)
	{
		switch(oncounter)
		{
			case 0: 
					FRONT_OFF;
					LEFT_OFF;
					RIGHT_OFF;
					BACK_OFF;				
					break;
			case 1: 	on=1;
					lightset1(200, 100);
					break;
			case 2: 	on=1;
					lightset2(200, 200);
					break;
			case 3: 	on=1;
					lightset3(200, 120);
					break;
			case 4: 	on=1;
					lightset4(200, 1000);
					break;
			case 5: 	on=1;
					lightset5(200, 300);
				  	oncounter = 0;
					break;
				
		}
		_delay_ms(1);
	}
	

	


	return 0;
}

ISR(INT0_vect)
{
	 on=0;
	 oncounter++;
}

